<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header("Location: login.php");
    exit();
}

include 'koneksi.php';

// Fetch counts
$query_buku = "SELECT COUNT(*) as total FROM buku";
$result_buku = mysqli_query($conn, $query_buku);
$row_buku = mysqli_fetch_assoc($result_buku);
$total_buku = $row_buku['total'];

$query_siswa = "SELECT COUNT(*) as total FROM users";
$result_siswa = mysqli_query($conn, $query_siswa);
$row_siswa = mysqli_fetch_assoc($result_siswa);
$total_siswa = $row_siswa['total'];

// Placeholder for transaksi, since no table
$total_transaksi = 0; // Or fetch from a table if exists
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Perpustakaan</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="dashboard-container">
        <div class="dashboard-header">
            <h1>Selamat Datang, <?php echo $_SESSION['nama']; ?>!</h1>
            <p>Anda login sebagai: <strong><?php echo $_SESSION['level']; ?></strong></p>
        </div>

        <div class="stats-container">
            <div class="stat-card">
                <h3><?php echo $total_buku; ?></h3>
                <p>Total Buku</p>
            </div>
            <div class="stat-card">
                <h3><?php echo $total_transaksi; ?></h3>
                <p>Total Transaksi</p>
            </div>
            <div class="stat-card">
                <h3><?php echo $total_siswa; ?></h3>
                <p>Total Siswa</p>
            </div>
        </div>

        <div class="nav-container">
            <a href="tampilbuku.php" class="nav-card">
                <h4>Data Buku</h4>
                <p>Kelola koleksi buku perpustakaan</p>
            </a>
            <a href="transaksi.php" class="nav-card">
                <h4>Transaksi Pinjam</h4>
                <p>Lihat dan kelola transaksi peminjaman</p>
            </a>
            <a href="logout.php" class="nav-card" onclick="return confirm('Yakin ingin keluar?')">
                <h4>Logout</h4>
                <p>Keluar dari sistem</p>
            </a>
        </div>
    </div>
</body>
</html>
