-- Membuat database perpustakaan
CREATE DATABASE IF NOT EXISTS db_perpustakaan;
USE db_perpustakaan;

-- Tabel admin untuk login dan registrasi
CREATE TABLE IF NOT EXISTS admin (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nama_admin VARCHAR(255) NOT NULL,
    username VARCHAR(255) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    level ENUM('admin', 'user') DEFAULT 'user'
);

-- Tabel users untuk login dan registrasi user
CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(255) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    role ENUM('user', 'admin') DEFAULT 'user'
);

-- Tabel buku untuk manajemen koleksi buku
CREATE TABLE IF NOT EXISTS buku (
    id_buku INT AUTO_INCREMENT PRIMARY KEY,
    isbn VARCHAR(20) UNIQUE,
    judul VARCHAR(255) NOT NULL,
    pengarang VARCHAR(255) NOT NULL,
    penerbit VARCHAR(255) NOT NULL,
    tahun_terbit INT NOT NULL,
    stok INT DEFAULT 0,
    rak VARCHAR(50)
);

-- Data awal untuk testing
INSERT INTO admin (nama_admin, username, password, level) VALUES
('Administrator', 'admin', 'admin123', 'admin'),
('User Test', 'user', 'user123', 'user');

INSERT INTO buku (isbn, judul, pengarang, penerbit, tahun_terbit, stok, rak) VALUES
('978-602-03-1234-5', 'Belajar PHP', 'John Doe', 'Penerbit ABC', 2023, 10, 'Rak A1'),
('978-602-03-5678-9', 'Database MySQL', 'Jane Smith', 'Penerbit XYZ', 2022, 5, 'Rak B2');
